/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build.xml;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemIdentifierTableLogo7;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileWDToXmlLogo;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.udf.GuidVersionMgr;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFParameterItem;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.util.Enumeration;
import java.util.Iterator;
import org.dom4j.Element;

public class CompileWDToXmlUDF
extends CompileWDToXmlLogo {
    public Element compile(WiringDiagram wd, Element parent) {
        this.fHW = wd.getHardware();
        Element udfBlockNode = parent.addElement("UDFBlock");
        UDFBlock udfBlock = ((WiringDiagramUDF)wd).initUDFBlock();
        if (wd.getErrors().size() > 0) {
            Enumeration errors = wd.getErrors().keys();
            if (errors.hasMoreElements()) {
                String error = (String)errors.nextElement();
                if (error.equals("msg.notReachableBlocks")) {
                    udfBlock.setValidity(21);
                } else if (error.equals("msg.noBlocks")) {
                    udfBlock.setValidity(22);
                } else {
                    udfBlock.setValidity(2);
                }
            }
        } else if (wd.getWarnings().size() > 0) {
            udfBlock.setValidity(1);
        } else {
            udfBlock.setValidity(0);
        }
        Element blocksNode = this.saveUDFInfo(udfBlock, udfBlockNode);
        udfBlockNode.addAttribute("inCounter", String.valueOf(((WiringDiagramUDF)wd).getInConnectorBlocks().size()));
        udfBlockNode.addAttribute("outCounter", String.valueOf(((WiringDiagramUDF)wd).getOutConnectorBlocks().size()));
        Element inGroupNode = blocksNode.addElement("InGroup");
        Iterator<Block> inputBlocks = ((WiringDiagramUDF)wd).getInConnectorBlocks().iterator();
        while (inputBlocks.hasNext()) {
            this.acceptVisit(inputBlocks.next(), inGroupNode);
        }
        Element outGroupNode = blocksNode.addElement("OutGroup");
        Iterator<Block> outputBlocks = ((WiringDiagramUDF)wd).getOutConnectorBlocks().iterator();
        while (outputBlocks.hasNext()) {
            this.acceptVisit(outputBlocks.next(), outGroupNode);
        }
        return udfBlockNode;
    }

    public Element compile(UDFBlock udfBlock, Element parent) {
        Element udfBlockNode = parent.addElement("UDFBlock");
        Element blocksNode = this.saveUDFInfo(udfBlock, udfBlockNode);
        udfBlockNode.addAttribute("inCounter", String.valueOf(udfBlock.getInDeputyBlockCount()));
        udfBlockNode.addAttribute("outCounter", String.valueOf(udfBlock.getOutDeputyBlockCount()));
        Element inGroupNode = blocksNode.addElement("InGroup");
        for (int i = 0; i < udfBlock.getInDeputyBlockCount(); ++i) {
            this.acceptVisit(udfBlock.getInputDeputy(i), inGroupNode);
        }
        Element outGroupNode = blocksNode.addElement("OutGroup");
        for (int i = 0; i < udfBlock.getOutDeputyBlockCount(); ++i) {
            this.acceptVisit(udfBlock.getOutputDeputy(i), outGroupNode);
        }
        return udfBlockNode;
    }

    public Element visit(InBlockConnector connector, Element parenentNode) {
        int blockNumber;
        int opcode;
        Element connectorNode = parenentNode.addElement("InConnector").addAttribute("negate", String.valueOf(connector.isNegated()));
        Block prev = connector.getLinkedBlock();
        if (prev instanceof DeputyBlock) {
            UDFBlock parent = ((DeputyBlock)prev).getParent();
            opcode = prev.getOpcode(this.fHW, 0);
            blockNumber = this.getDeputyBlockNumber((DeputyBlock)prev);
            connectorNode.addAttribute("parent", String.valueOf(parent.getNumber())).addAttribute("inCounter", String.valueOf(parent.getInDeputyBlockCount())).addAttribute("outCounter", String.valueOf(parent.getOutDeputyBlockCount())).addAttribute("parentIndex", String.valueOf(((DeputyBlock)prev).getIndexOfParentUDF()));
        } else if (prev != null) {
            opcode = prev.getOpcode(this.fHW, 0);
            blockNumber = prev.getNumber();
        } else {
            opcode = Integer.valueOf("255");
            blockNumber = -1;
        }
        return connectorNode.addAttribute("opcode", String.valueOf(opcode)).addAttribute("blockNumber", String.valueOf(blockNumber));
    }

    public Element visit(UDFBlock block, Element parenentNode) {
        return this.compile(block, parenentNode);
    }

    public Element visit(DeputyBlock block, Element parenentNode) {
        Element blockNode = parenentNode.addElement("Block");
        blockNode.addAttribute("opcode", String.valueOf(block.getOpcode(this.fHW, 0))).addAttribute("blockNumber", String.valueOf(this.getDeputyBlockNumber(block))).addAttribute("name", block.getUserDefinedName());
        this.saveInconnectorsInfo(block, blockNode);
        return blockNode;
    }

    private int getDeputyBlockNumber(DeputyBlock block) {
        int adType = block.getBinaryAnalogType();
        int inpuType = block.isInputType() ? 0 : 1;
        return block.getNumber() | adType << 6 | inpuType << 7;
    }

    private Element saveUDFInfo(UDFBlock udfBlock, Element udfBlockNode) {
        udfBlockNode.addAttribute("guidValue", String.valueOf(udfBlock.getGuid())).addAttribute("identifier", udfBlock.getIdentifier()).addAttribute("comments", udfBlock.getComment()).addAttribute("version", udfBlock.getVersion()).addAttribute("blockNumber", String.valueOf(udfBlock.getNumber())).addAttribute("inCounter", String.valueOf(udfBlock.getInDeputyBlockCount())).addAttribute("outCounter", String.valueOf(udfBlock.getOutDeputyBlockCount())).addAttribute("validity", String.valueOf(udfBlock.getValidity()));
        Element guidListNode = udfBlockNode.addElement("GuidList");
        for (GuidVersionMgr.GuidVerPair entry : udfBlock.getGuidManager().getGuidMap()) {
            Element guidNode = guidListNode.addElement("Guid");
            guidNode.addAttribute("value", String.valueOf(entry.first()));
            if (entry.second() == null) continue;
            guidNode.addAttribute("version", (String)entry.second());
        }
        UDFBlockParameter parameter = (UDFBlockParameter)udfBlock.getParameter();
        Element parameterNode = udfBlockNode.addElement("Parameter");
        Block block2 = null;
        ParameterItem sourceItem = null;
        ParameterItemIdentifierTableLogo7 identifierTable = (ParameterItemIdentifierTableLogo7)this.fHW.getProperty("parameterItemIdentifierTable");
        for (Object item : parameter.getParameterItems()) {
            UDFParameterItem udfItem = (UDFParameterItem)item;
            sourceItem = udfItem.getSourceParameterItem();
            block2 = sourceItem.getParameter().getBlock();
            parameterNode.addElement(identifierTable.getXmlIdentifier(sourceItem.getParameter(), sourceItem.getIdentifier())).addAttribute("opcode", String.valueOf(block2.getOpcode(this.fHW, 0))).addAttribute("blockNumber", String.valueOf(block2.getNumber())).addAttribute("name", String.valueOf(udfItem.getIdentifier()));
        }
        Element blocksNode = udfBlockNode.addElement("Blocks");
        for (Block block2 : udfBlock.getBlocks()) {
            if (block2.getClass() == DeputyBlock.class || block2.getClass() == InputBlock.class || block2.getClass() == AnalogInputBlock.class || block2.getClass() == OutputBlock.class || block2.getClass() == AnalogOutputBlock.class) continue;
            this.acceptVisit(block2, blocksNode);
        }
        return blocksNode;
    }

    protected void storeTimerOrReference(TimeValueProperties property, Element parenentNode) {
        int value;
        TimeUnit tu = property.getCurrentValue();
        parenentNode.addAttribute("isReference", String.valueOf(property.isReference())).addAttribute("lowMin", String.valueOf(tu.getLowMin())).addAttribute("lowMax", String.valueOf(tu.getLowMax())).addAttribute("highMin", String.valueOf(tu.getHighMin())).addAttribute("highMax", String.valueOf(tu.getHighMax()));
        int[] time = tu instanceof Reference ? this.getLogoTime((Reference)tu) : tu.getLogoTime();
        if (property.isReference()) {
            Block referenceBlock = property.getReference().getParameter().getBlock();
            if (referenceBlock instanceof UDFBlock) {
                parenentNode.addAttribute("udfIden", property.getReference().getIdentifier());
            }
            value = Util.makeDoubleWord(time[1], time[0], referenceBlock.getOpcode(), 0);
        } else {
            value = property.getCurrentValue() instanceof UnlimitedHours ? Util.makeDoubleWord(time[3], time[2], time[1], time[0] | 0x40) : Util.makeWord(time[1], time[0]);
        }
        parenentNode.addText(String.valueOf(value));
    }

    protected void storeIntegerOrBlockReference(IntegerOrBlockReference property, Element parenentNode) {
        int value;
        parenentNode.addAttribute("isReference", String.valueOf(property.isReference())).addAttribute("max", String.valueOf(property.getIntValueProperties().getMax())).addAttribute("min", String.valueOf(property.getIntValueProperties().getMin())).addAttribute("incre", String.valueOf(property.getIntValueProperties().getInc()));
        if (property.isReference()) {
            Block referenceBlock = property.getReferenceToBlock();
            if (referenceBlock instanceof UDFBlock) {
                parenentNode.addAttribute("udfIden", property.getReference().getIdentifier());
            }
            value = Util.makeSignedDoubleWord(0, 0, referenceBlock.getNumber(), referenceBlock.getOpcode(referenceBlock.getHardware(), 0));
        } else {
            value = property.getValue();
        }
        parenentNode.addText(String.valueOf(value));
    }

    private int[] getLogoTime(Reference tu) {
        int aWord = 0;
        aWord = tu.getTimeUnit() instanceof UnlimitedHours ? 0 : (aWord |= tu.getTimeUnit().getLogoTime()[0] << 8);
        return new int[]{(aWord += tu.getReference().getParameter().getBlock().getNumber()) >> 8 & 0xFF, aWord & 0xFF};
    }
}

